% generate a set of positions of TX and RX
clear;
NTRX = 10000;
L = 2;

fc = 30e9;
c = 3e8;
BW_des =  1.5e9;
Ptx = 10;%dBm
TransmitDistance = 20;% average total transmit distance
TDrange = 0; % actual dist ~ U[TransmitDistance-TDrange/2, TransmitDistance+TDrange/2]

TRX = zeros(6,NTRX);
n = 1;
m = 1;
while n<=NTRX
    tempTRX = randn(6,1);
    curTD = TransmitDistance+TDrange*(rand(1,1)-0.5);
    p = rand(1)*0.3+0.35;
    tempTRX(1:3) = tempTRX(1:3)./norm(tempTRX(1:3))*curTD*p;
    tempTRX(4:6) = tempTRX(4:6)./norm(tempTRX(4:6))*curTD*(1-p);
    tempTRX([3,6]) = abs(tempTRX([3,6]));% on the same side of RIS
    z = Deltaa(L,tempTRX,fc);
    % if z>1
    if z>0
        TRX(:,n) = tempTRX;
        n = n+1;
        % if mod(n,100)==0
        %     n
        % end
    end
   
    m = m+1;
end

save('TRX_same_dist20.mat')


function [deltaa] = Deltaa(L,TRX,fc)
x1 = TRX(1);y1 = TRX(2);z1 = TRX(3);
x2 = TRX(4);y2 = TRX(5);z2 = TRX(6);
c = 3e8;
Lb = c/fc;
spac = Lb*8;

N = round(L/spac);
xcoord=linspace(-L/2,L/2,N);
ycoord=xcoord;
[xx,yy]=meshgrid(xcoord,ycoord);
% coord_mat=xx+1i*yy;
a = (sqrt((xx-x1).^2+(yy-y1).^2+z1^2)+sqrt((xx-x2).^2+(yy-y2).^2+z2^2))/2;
deltaa = max(a(:))-min(a(:));
end


